// NotifyThread.java
// 13 feb Olof

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import Globals;

public class NotifyThread extends Thread {
  public Letter2 L;
  private int startX, startY, endX, endY, x ,y;
  Graphics g;
  ShowMobileIPCanvas canvas;
  Agent Ag;
  Agent fromAgent;

  public void start(Agent fromAgent, Agent Ag,
		    ShowMobileIPCanvas father) {
    this.canvas = father; 
    this.startX = fromAgent.x; this.startY = fromAgent.y; 
    this.endX = Ag.x; this.endY = Ag.y;
    this.fromAgent = fromAgent;
    this.x = fromAgent.x; this.y = fromAgent.y;
    this.Ag = Ag;
    L = new Letter2(canvas);
    g = canvas.getGraphics();
    super.start(); // run() MUST be started from Thread.start()
  }
  
  public void run() {
    Globals.actionAllowed = false; // MH interaction disabled
    L.drawLetter(g, fromAgent.x, fromAgent.y); 

    canvas.frame.setCont();

    // Define letter informationText
    L.info =  "Contains a notification from  " 
              +fromAgent.name+ " that MH no longer is at "
              +fromAgent.name + ".";
    run1(endX, endY);
    if (Globals.FA[0] != Ag) 
      Ag.believeMH = Globals.FA[0];
    else 
      Globals.FA[0].believeMH = null;
    L.eraseLetter(g);
    canvas.frame.setDisabled(); // Disables buttons
    
    int i = 0;
    while (Ag != Globals.FA[i])
      i++;
    if (Globals.dialogExist[i])
      Globals.Dialogs[i].reDraw2(); // Redraws Dialog
    Globals.actionAllowed = true; // MH interaction allowed
    if (! (Globals.MH.needUpdate[1] || Globals.MH.needUpdate[2] 
	   || Globals.MH.needUpdate[3])){ // no more notifythreads needed
      //canvas.frame.textArea1.append("\n");
      if (Globals.doReg) {
	Globals.doReg = false;
	Globals.MH.connected = Globals.newAgent;
	canvas.registrationMH();
      }
      if (Globals.doInc) {
	Globals.doInc = false;
	Globals.MH.connected = Globals.newAgent;
	Globals.MH.connected.believeMH = Globals.newAgent;
	canvas.includationMH();
      }
    }
  } // end run()

  // Animation of Letter
  private void run1(int toX, int toY) {
    int biggest = Math.max(Math.abs(toY - y), Math.abs(toX - x));
    float dx = (float) (toX - x) / biggest;
    float dy = (float) (toY - y) / biggest;
    float xtemp = (float) x;
    float ytemp = (float) y; 
    float minToY = toY - Math.abs(dy), maxToY = toY + Math.abs(dy);
    float minToX = toX - Math.abs(dx), maxToX = toX + Math.abs(dx);
  
  
    //  while ((x != toX) && (y != toY)) { 
    while (!(((ytemp < maxToY) && (ytemp > minToY)) && 
	     ((xtemp < maxToX) && (xtemp > minToX)))) {
      if (Globals.contAllowed) { // Check whether user pressed Stop 
     	xtemp  = xtemp+dx;
	ytemp  = ytemp+dy;
	g.setColor(Color.lightGray);
	g.fillRect(x-1, y-1, 22, 14);
	x = (int) xtemp;
	y = (int) ytemp;
	canvas.paint(g); 
	L.drawLetter(g, x, y); 
	 try {  
	  sleep(Globals.sleepTime);
	 } catch (InterruptedException e) {break;}
      }
      else { // Wait for user to press continue
	canvas.frame.setStop(); // Activate Stopbutton
	this.suspend();
      }
    } // end while
   
  }
}
	
